/**********************************************
*  Window - David Chapman
*
*  This file opens a window for videogames.....
*  It sets up the opengl, keyboard, and sound
*  in the simplest way good enough for a FPS
*  game
**********************************************/

#ifndef _WINDOW_H_
#define _WINDOW_H_

typedef struct Window {
	int x, y; /*window size*/

	/*button motion*/
	unsigned char keys[256];
	unsigned char speckeys[256];
	unsigned char click[3];

	/*frame rate*/
	float spf;	/*seconds per frame*/
	float time;	/*total elapsed time in seconds*/
} Window;
extern Window window;	/*only a single window object*/

int WindowCreate(
	int argc, char **argv,
	void (*initfunc)(),
	void (*updatefunc)(), 
	void (*drawfunc)(), 
	void (*keyfunc)(), 
	void (*mousefunc)(int x, int y),
	int width, int height, int fullscreen
);

#endif /* _WINDOW_H_ */
