#include <stdio.h>
#include "tcp.h"
#include "buffered_tcp.h"

#define NUM_CLIENTS 1
#define TRUE 1
#define FALSE 0
#define MEGABYTE (1024*1024)
int serverSock;
volatile TcpBuffer *clientSock[NUM_CLIENTS];

typedef struct GamePacket {
	char string[512];
} GamePacket;
GamePacket packet;

void UpdateGamestate(int i, GamePacket *packet);
int ReadPacket(int socket, void *packet, int packetSize);

int main() {

	int i;

	// Wait for clients to connect
	serverSock = TcpServerEstablish("7777");
	for (i=0; i<NUM_CLIENTS; i++) {
		clientSock[i] = BufferedTcpServerAcceptClient(serverSock, MEGABYTE);
	}


	// Loop Forever
	int numFrames=0;
	while (1) {

		printf("----------------\n");
		printf("  server frame %d\n", numFrames);

		// Read Client Data Packets
		for (i=0; i<NUM_CLIENTS; i++) {

			// Read all queued up packets
			while ( BufferedTcpPeekRecv(clientSock[i], sizeof(packet)) )
			{
				BufferedTcpRecv(clientSock[i], &packet, sizeof(packet));
				UpdateGamestate(numFrames, &packet);
			}
		}

		// Update Simulation

		// Write Out Gamestate TO Clients
		for (i=0; i<NUM_CLIENTS; i++)
			BufferedTcpSend(clientSock[i],&packet,sizeof(packet));

		//usleep(20000);
		usleep(500000);

		numFrames++;

	}

	return 0;
}

void UpdateGamestate(int i, GamePacket *packet) {

	printf("Frame %d says '%s'\n", i, packet->string);
}

