#include <stdio.h>
#include <stdlib.h>
#include "tcp.h"
#include "buffered_tcp.h"

#define TRUE  1
#define FALSE 0

typedef struct GamePacket {
	char string[512];
} GamePacket;
GamePacket packet;

#define MEGABYTE (1024*1024)

int ReadPacket(int socket, void *packet, int packetSize);
void UpdateClientSimulation(int frame, GamePacket *packet);

int main() {

	// Connect to the deticated server
	volatile TcpBuffer *bufSock = BufferedTcpClientConnect("localhost", "7777", 1, 0, MEGABYTE);

	// Main Game Loop
	int numFrames=0;
	while (numFrames < 100) {

		printf("----------------\n");
		printf("  client frame %d\n", numFrames);

		// The sent client gamestate to server
		sprintf(packet.string, "hello %d", numFrames);

		BufferedTcpSend(bufSock,&packet,sizeof(packet));

		// Recv REAL gamestate from server
		while ( BufferedTcpPeekRecv(bufSock, sizeof(packet)) )
		{
			BufferedTcpRecv(bufSock,&packet,sizeof(packet));
			UpdateClientSimulation(numFrames, &packet);
		}

		// wait for next packet
		//usleep(20000);
		usleep(500000);

		numFrames++;
	}

	return 0;
}


void UpdateClientSimulation(int frame, GamePacket *packet)
{
}


