#include <stdio.h>
#include <stdlib.h>
#include "tcp.h"

#define TRUE  1
#define FALSE 0

typedef struct GamePacket {
	char string[512];
} GamePacket;
GamePacket packet;

int ReadPacket(int socket, void *packet, int packetSize);
void UpdateClientSimulation(int frame, GamePacket *packet);

int main() {

	// Connect to the deticated server
	int sock = TcpClientConnect("localhost", "7777", 1, 0);


	// Main Game Loop
	int numFrames=0;
	while (1) {

		printf("----------------\n");
		printf("  client frame %d\n", numFrames);

		// The sent client gamestate to server
		sprintf(packet.string, "hello %d", numFrames);
		TcpSendFully(sock,&packet,sizeof(packet), 0);

		// Recv REAL gamestate from server
		while (  ReadPacket(sock,&packet,sizeof(packet)) )
			UpdateClientSimulation(numFrames, &packet);

		// wait for next packet
		usleep(20000);

		numFrames++;
	}

	return 0;
}


void UpdateClientSimulation(int frame, GamePacket *packet)
{
}

//-----------------------
// NOTICE: This assumes the TCP window is large enough to
//    hold a game packet.  If it wasn't we would need to
//    to implement our own 'packet-buffering'
//    via threads or non-blocking sockets
//-----------------------
int ReadPacket(int socket, void *packet, int packetSize) {

	// Peek for data to receive
	int peekBytes=recv(socket, packet, packetSize,  MSG_PEEK|MSG_DONTWAIT);
printf("peekBytes: %d\n", peekBytes);
	if (peekBytes == packetSize) {  // if the entire packet is in the TCP window....

		// Read the data packet
		int readBytes=recv(socket, packet, packetSize,  0);
		if (readBytes == packetSize)
			return TRUE;
	}	

	return FALSE;
}


