#ifndef _BUFFERED_TCP_H_
#define _BUFFERED_TCP_H_

#include <pthread.h>
#include "tcp.h"

#define byte unsigned char

typedef struct TcpBuffer {
	int sock;

	// buffers
	byte *recvBuf;
	byte *sendBuf;
	int sendBufSize;
	int recvBufSize;
	int bufMax;

	// worker threads
	pthread_t       sendBufThread;
	pthread_t       recvBufThread;
	pthread_mutex_t sendBufLock;
	pthread_mutex_t recvBufLock;
} TcpBuffer;

int  BufferedTcpPeekRecv(volatile TcpBuffer *tb, int size);
void BufferedTcpRecv(volatile TcpBuffer *tb, void *data, int size);
void BufferedTcpSend(volatile TcpBuffer *tb, void *data, int size);
TcpBuffer *BufferedTcpServerAcceptClient(int sockfd, int bufsize);
TcpBuffer *BufferedTcpClientConnect(char *host, char *port, int numretry, int uwait, int bufsize);

#endif // _BUFFERED_TCP_H_
