/* A simple server in the internet domain using TCP
   The port number is passed as an argument */
#include "tcp.h"

int TcpClientConnect(char *host, char *port, int numretry, int uwait) {

	struct hostent *server;
	struct sockaddr_in serv_addr;
	int sockfd, portno;

	/*remember our name (for errors)*/
	char hostname[256];
	gethostname(hostname, 256);

	/*establish a client socket*/
	sockfd = socket(AF_INET, SOCK_STREAM, 0);
	if (sockfd < 0) {
		fprintf(stderr, "ERROR opening socket on client %s\n", hostname);
		exit(83);
	}

	/*This is a lifesaver...tell the kernel to cleanup the socket after death*/
	struct linger ling;
	ling.l_onoff = 1;	/*sockets must linger*/
	ling.l_linger = 0;	/*for zero seconds after death*/
	setsockopt(sockfd, SOL_SOCKET, SO_LINGER, (struct linger*)&ling,sizeof(struct linger));

	/*dns resolve the hostname*/
	server = gethostbyname(host);
	if (server == NULL) {
		fprintf(stderr, "ERROR, no such host %s from client %s\n", host, hostname);
		exit(83);
	}
	memset((char *) &serv_addr, 0, sizeof(serv_addr));
	serv_addr.sin_family = AF_INET;
	bcopy((char *)server->h_addr, (char *)&serv_addr.sin_addr.s_addr, server->h_length);
	portno = atoi(port);
	serv_addr.sin_port = htons(portno);

	/*connect to the server...in a loop, and wait evey time*/
	while (connect(sockfd,(const struct sockaddr *)&serv_addr,sizeof(serv_addr)) < 0) {
		if (numretry == 0) {
			fprintf(stderr, "ERROR connecting to host %s from client %s\n", host, hostname);
			exit(83);
		}
		numretry--;
		usleep(uwait);
	}

	return sockfd;
}
int TcpServerEstablish(const char *port) {

	/*remember our name (for errors)*/
	char hostname[256];
	gethostname(hostname, 256);

	/*Open the socket*/
	struct sockaddr_in serv_addr;
	int sockfd = socket(AF_INET, SOCK_STREAM, 0);
	if (sockfd < 0) {
		fprintf(stderr, "ERROR opening socket on server %s\n", hostname);
		exit(83);
	}

	/*This is a lifesaver...tell the kernel to cleanup the socket after death*/
	struct linger ling;
	ling.l_onoff = 1;	/*sockets must linger*/
	ling.l_linger = 0;	/*for zero seconds after death*/
	setsockopt(sockfd, SOL_SOCKET, SO_LINGER, (struct linger*)&ling,sizeof(struct linger));

	/*Bind it to a port*/
	memset(&serv_addr, 0, sizeof(serv_addr));
	int portno = atoi(port);
	serv_addr.sin_family = AF_INET;
	serv_addr.sin_addr.s_addr = INADDR_ANY;
	serv_addr.sin_port = htons(portno);
	if (bind(sockfd, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0) {
		fprintf(stderr, "ERROR on binding port %s on server %s\n", port, hostname);
		exit(83);
	}

	return sockfd;
}
int TcpServerAcceptClient(int sockfd) {

	struct sockaddr_in cli_addr;
	int clilen = sizeof(cli_addr);

	/*wait for and accept a client*/
	listen(sockfd,5);	/*5 is a magic number, I don't know or care why it's 5*/
	int newsockfd = accept(sockfd, (struct sockaddr*)&cli_addr, &clilen);
	if (newsockfd < 0) {
		fprintf(stderr, "ERROR on accept\n");
		exit(83);
	}

	/*This is a lifesaver...tell the kernel to cleanup the socket after death*/
	struct linger ling;
	ling.l_onoff = 1;	/*sockets must linger*/
	ling.l_linger = 0;	/*for zero seconds after death*/
	setsockopt(newsockfd, SOL_SOCKET, SO_LINGER, (struct linger*)&ling,sizeof(struct linger));

	return newsockfd;
}
void TcpSendFully(int sock, void *buf, int bufSize, int flag)
{
	// Send "might" fragment....
	//  Until we send all the bytes
	int sentBytes = 0;
	while ( sentBytes < bufSize ) {

		// try to send the remaining bytes
		int remaining   = bufSize-sentBytes;
		char *remainBuf = (char*)(buf) +  sentBytes; //pointer arithmetic
		int myBytes = send(sock, remainBuf, remaining, 0);

		// If we sent anything, then count the "sentBytes"
		if (myBytes != -1)
			sentBytes += myBytes;
	}
}
void SplitHostAddress(char **ip, char **port, char *addr) {

	/*split the addr into IP address and port...
	  Address is format iii.iii.iii.iii:pppppp...so all we need
	  to do is take the colon, and split into two strings
	  iii.iii.iii.iii    and   pppppp   !*/
	int colonIdx = 0;
	while (addr[colonIdx] != ':' && addr[colonIdx] != '\0')
		colonIdx++;

	/*if there's no colon, then the whole thing is IP*/
	if (addr[colonIdx] != ':') {
		*ip = (char*)addr;
		*port = NULL;
		return;
	}

	/*split the string*/
	addr[colonIdx] = '\0';
	*ip = (char*)addr;
	*port = (char*)(addr+colonIdx+1);
}
