#include <stdio.h>
#include "tcp.h"

#define NUM_CLIENTS 1
#define TRUE 1
#define FALSE 0
int serverSock;
int clientSock[NUM_CLIENTS];

typedef struct GamePacket {
	char string[512];
} GamePacket;
GamePacket packet;

void UpdateGamestate(int i, GamePacket *packet);
int ReadPacket(int socket, void *packet, int packetSize);

int main() {

	int i;

	// Wait for clients to connect
	serverSock = TcpServerEstablish("7777");
	for (i=0; i<NUM_CLIENTS; i++) {
		clientSock[i] = TcpServerAcceptClient(serverSock);
	}


	// Loop Forever
	int numFrames=0;
	while (1) {

		printf("----------------\n");
		printf("  server frame %d\n", numFrames);

		// Read Client Data Packets
		for (i=0; i<NUM_CLIENTS; i++) {

			// Read all queued up packets
			while ( ReadPacket(clientSock[i],&packet,sizeof(packet)) )
				UpdateGamestate(numFrames, &packet);
		}

		// Update Simulation

		// Write Out Gamestate TO Clients
		for (i=0; i<NUM_CLIENTS; i++)
			TcpSendFully(clientSock[i],&packet,sizeof(packet), 0);

		usleep(20000);

		numFrames++;

	}

	return 0;
}

//-----------------------
// NOTICE: This assumes the TCP window is large enough to
//    hold a game packet.  If it wasn't we would need to
//    to implement our own 'packet-buffering'
//    via threads or non-blocking sockets
//-----------------------
int ReadPacket(int socket, void *packet, int packetSize) {

	// Peek for data to receive
	int peekBytes=recv(socket, packet, packetSize,  MSG_PEEK|MSG_DONTWAIT);
	if (peekBytes == packetSize) {  // if the entire packet is in the TCP window....

		// Read the data packet
		int readBytes=recv(socket, packet, packetSize,  0);
		if (readBytes == packetSize)
			return TRUE;
	}	

	return FALSE;
}

void UpdateGamestate(int i, GamePacket *packet) {

	printf("Frame %d says '%s'\n", i, packet->string);
}

