#include "buffered_tcp.h"

// Local prototyes and macros
TcpBuffer *BufferedTcpAlloc(int bufsize);
void BufferedTcpStartThreads(TcpBuffer *tb);
void Buffered_GetFirstBlock(byte *block, int blockSize, byte *buf, int *pBufSize);
#define MIN(a,b)  (  ((a)<(b)) ? (a) : (b)  )

//----------------------------------
//----------------------------------
// These functions are for accepting buffered TCP connections
//----------------------------------
//----------------------------------
TcpBuffer *BufferedTcpServerAcceptClient(int sockfd, int bufsize)
{
	TcpBuffer *buf = BufferedTcpAlloc(bufsize);
	buf->sock      = TcpServerAcceptClient(sockfd);
	BufferedTcpStartThreads( buf );
	return buf;
}
TcpBuffer *BufferedTcpClientConnect(char *host, char *port, int numretry, int uwait, int bufsize)
{
	TcpBuffer *buf = BufferedTcpAlloc(bufsize);
	buf->sock      = TcpClientConnect(host, port, numretry, uwait);
	BufferedTcpStartThreads( buf );
	return buf;
}
TcpBuffer *BufferedTcpAlloc(int bufsize)
{
	TcpBuffer *r = (TcpBuffer*)malloc(sizeof(TcpBuffer));
	r->sock = -1;
	r->recvBuf = malloc(bufsize);
	r->sendBuf = malloc(bufsize);
	r->bufMax  = bufsize;
	r->sendBufSize = 0;
	r->recvBufSize = 0;
	return r;
}

//----------------------------------
//----------------------------------
// These functions are "worker" threads
//  Their job is to wait for information
//  to pop onto the buffer, and
//----------------------------------
//----------------------------------
void *BufferedTcpRecvThread(void *_buf)
{
	int rt=-1;
	volatile TcpBuffer *buf = (TcpBuffer*)_buf;

	// Read as much as possible from the socket
	while(1) {
		// how much is possible?
		int   availableBytes = buf->bufMax - buf->recvBufSize;
		int   remainingBytes = MIN(2048, availableBytes);
		if (remainingBytes > 0) {
			// read it!
			char block[2048];
			rt=recv(buf->sock, block, remainingBytes, 0);
			if (rt > 0) {

				// copy it over!
				pthread_mutex_lock( &(buf->recvBufLock) );
				{
					byte *remainingBuf   = buf->recvBuf + buf->recvBufSize;
					memcpy(remainingBuf, block, rt);
					buf->recvBufSize += rt;
//char *sendBuf = (buf->sendBufSize > 0) ? buf->sendBuf : NULL;
//char *recvBuf = (buf->recvBufSize > 0) ? buf->recvBuf : NULL;
//printf("recv: '%s'   sendBuf: '%s'  recvBuf: '%s'  recvBuf=%p  reanainingBuf=%p\n", block, sendBuf, recvBuf, recvBuf, remainingBuf); fflush(stdout);
//printf("   buf->recvBufSize: %d\n", buf->recvBufSize);
//printf("   rt: %d\n", rt);
				}
				pthread_mutex_unlock( &(buf->recvBufLock) );
			}
		}

		usleep(1000);
	}
}
void *BufferedTcpSendThread(void *_buf)
{
	int rt=-1;
	byte block[2048];
	volatile TcpBuffer *buf = (TcpBuffer*)_buf;

	// Always write as much as possible to the socket
	while (1) {
		// is there any data to write?
		if (buf->sendBufSize > 0) {

			int blockSize = MIN(2048, buf->sendBufSize);
			//printf("blockSize: %d\n", blockSize);

			// copy the first 2048 bytes to "block"
			pthread_mutex_lock( (pthread_mutex_t*)(&(buf->sendBufLock)) );
			Buffered_GetFirstBlock(
				block,blockSize,
				buf->sendBuf, &(buf->sendBufSize));
//printf("block: %s\n", block);
//printf("sendBufSize: %d\n", buf->sendBufSize);
			pthread_mutex_unlock( (pthread_mutex_t*)(&(buf->sendBufLock)) );

			// write the "block" to the socket
//char *sendBuf = (buf->sendBufSize > 0) ? buf->sendBuf : NULL;
//char *recvBuf = (buf->recvBufSize > 0) ? buf->recvBuf : NULL;
//printf("send: '%s'   sendBuf: '%s'  recvBuf: '%s'\n", block, sendBuf, recvBuf); fflush(stdout);
			TcpSendFully(buf->sock, block, blockSize, 0);
		}

		usleep(1000);
	}	
}
void BufferedTcpStartThreads(TcpBuffer *tb) {
	pthread_mutex_init(&(tb->sendBufLock), 0);
	pthread_mutex_init(&(tb->recvBufLock), 0);
	pthread_create(&(tb->recvBufThread), 0, BufferedTcpRecvThread, tb);
	pthread_create(&(tb->sendBufThread), 0, BufferedTcpSendThread, tb);
}
void Buffered_GetFirstBlock(byte *block, int blockSize, byte *buf, int *pBufSize)
{
	// get X bytes from the buffer...
	int currentBytes   = MIN(blockSize, *pBufSize);
	int remainingBytes = *pBufSize - currentBytes;

	// copy first X bytes to block
	memcpy (block, buf, currentBytes);

	// shift the remaining stuff X bytes down
	//  to cover the removed block
	memmove(buf, buf+currentBytes, remainingBytes);
	*pBufSize = remainingBytes;
}


//----------------------------------
//----------------------------------
// These functions are the send/recv interface
//  they queue up data for the worker threads to
//  pass to the socket asynchronously
//----------------------------------
//----------------------------------
int  BufferedTcpPeekRecv(volatile TcpBuffer *tb, int size) {
	return ( tb->recvBufSize >= size );
}
void BufferedTcpSend(volatile TcpBuffer *tb, void *data, int size) {

	// make sure there's enough room
	if (tb->bufMax < size) {
		printf("ERROR: TcpBuffer not enough room %d to send %d bytes\n", tb->bufMax, size); fflush(stdout);
		exit(1);
	}
	// wait for the room to free up
	while (  (tb->bufMax - tb->sendBufSize)  <  size) {}

	// send the data out
	pthread_mutex_lock( (pthread_mutex_t*)(&(tb->sendBufLock)) );
	{
		byte *dst = tb->sendBuf + tb->sendBufSize;
		memcpy(dst, data, size);
		tb->sendBufSize += size;
//printf("***** BTS ******   tb->sendBufSize: %d\n", tb->sendBufSize);
	}
	pthread_mutex_unlock( (pthread_mutex_t*)(&(tb->sendBufLock)) );

	//printf("BuffferedTcpSend: %s\n", data);
}
void BufferedTcpRecv(volatile TcpBuffer *tb, void *data, int size) {

	// make sure there's enough room
	if (tb->bufMax < size) {
		printf("ERROR: TcpBuffer not enough room %d to recv %d bytes\n", tb->bufMax, size); fflush(stdout);
		exit(1);
	}
	// wait for the data to arrive
	while (  tb->recvBufSize <  size) {}

	// read the data
	pthread_mutex_lock( (pthread_mutex_t*)(&(tb->recvBufLock)) );
//printf("BufferedTcpRecv1: %s\n", tb->recvBuf);
	Buffered_GetFirstBlock(
		data,size,
		tb->recvBuf, &(tb->recvBufSize));
//printf("   tb->recvBufSize: %d\n", tb->recvBufSize);
	pthread_mutex_unlock( (pthread_mutex_t*)(&(tb->recvBufLock)) );

	//printf("BuffferedTcpRecv2: %s\n", data);
}

